#ifndef __UART_H__
#define __UART_H__

#ifdef __cplusplus
extern "C" {
#endif

#define NOPARITY            0
#define ODDPARITY           1
#define EVENPARITY          2
#define MARKPARITY          3
#define SPACEPARITY         4

#define ONESTOPBIT          0
#define ONE5STOPBITS        1
#define TWOSTOPBITS         2

Bool OpenUart(U8 dwPort, U32 dwBaudRate, U8 Parity, U8 ByteSize, U8 StopBits);
U32 GetChars(U8 dwPort, U8 * buffer, U32 len, U32 timeout);
U32 SendChars(U8 dwPort, U8 * buffer, U32 len, U32 timeout);
void CloseUart(U8 dwPort);
void FlushUart(U8 dwPort);

#ifdef __cplusplus
};
#endif
#endif
